package XMLGenerator;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class XMLGenerator {
    private static String directoryPath;
    
	public static int Patienttotal = 500000;
	public static int Filenum = 20;
	public static int MaxDiseaseNum = 2;
	public static int MinSympNum = 2;
	public static int MinTreatNum = 2;
	public static int MaxSympNum = 5;
	public static int MaxTreatNum = 5;
	/**
	 * @param args
	 * @throws IOException 
	 */
	public static void main(String[] args) throws IOException {
		if (args.length > 0) {
			directoryPath = args[0];
		} else {
			JFileChooser fc = new JFileChooser();

			fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);

			if (fc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION) {
				directoryPath = fc.getSelectedFile().getCanonicalPath();
			} else {
				throw new IllegalArgumentException("Missing or wrong path.");
			}
		}
		
		File directory = new File(directoryPath);
		
		if (!directory.isDirectory()) {
			throw new IllegalArgumentException("Missing or wrong path.");
		}
    
		// TODO Auto-generated method stub
/*		
		String diseases[] = {
			"Hypertension", "Heart Attack", "Apoplexy", "Bronchitis",
			"Cirrhosis", "Gastric Ulcer", "Influenza", "Rheumatoid Arthritis",
			"Neurasthenia", "Cataract", "Heterotropia", "Pharyngitis",
			"Diabetes", "Headache", "Scabies", "Anemia",
			"Angina Pectoris", "Arteriosclerosis", "Leukemia", "Malnutrition"
		};
		String treatments[][] = {
			{"treat4", "treat5", "treat6"},
			{"treat1", "treat2", "treat3", "treat7"},
			{"treat8", "treat9"},
			{"treat1", "treat10", "treat11", "treat12"},
			{"treat4", "treat13"},
			{"treat2", "treat14", "treat15"},
			{"treat16"},
			{"treat6", "treat17"},
			{"treat6", "treat18", "treat19"},
			{"treat20", "treat21", "treat22", "treat10"},
			{"treat23", "treat24"},
			{"treat25", "treat15", "treat16"},
			{"treat26", "treat27"},
			{"treat28", "treat29", "treat30", "treat31"},
			{"treat31"},
			{"treat32", "treat33"},
			{"treat34", "treat22", "treat35"},
			{"treat36", "treat37", "treat38", "treat30"},
			{"treat39", "treat40"},
			{"treat41", "treat42", "treat43"}
		};
		String doctors[][] = {
			{"Brown", "Pope"},
			{"Smith", "Prior", "Henry"},
			{"Farmer", "Carter"},
			{"Stuart"},
			{"Trnuer", "Cook", "Baker"},
			{"Taylor", "Washington"},
			{"Johnson"},
			{"Tomson", "Robinson"},
			{"Strong"},
			{"Mark", "Charles", "Black"},
			{"White", "King"},
			{"Fox"},
			{"Cock", "Wolf"},
			{"Hill", "Waters"},
			{"Lake"},
			{"Bush", "Wood", "Flower"},
			{"Clinton", "Frank"},
			{"Short", "Richard", "Green"},
			{"David", "Peter"},
			{"Lily", "Victor", "Samuel"}
		};
		
		

		Random rd=new Random(System.currentTimeMillis());
		
		FileOutputStream outs[] = new FileOutputStream[Filenum];
		StringBuffer sbhead=new StringBuffer();
        sbhead.append("<MedicalDB>");
		for(int i=0; i<Filenum; i++){
			File xmlfile = new File("C:\\MedicalDB" + Integer.toString((Patienttotal/Filenum)*(i+1)) + ".xml");
			if (xmlfile.exists()){
				System.out.println("File exists!");
				return;
			}
			xmlfile.createNewFile();
			outs[i] = new FileOutputStream(xmlfile,true);
			outs[i].write(sbhead.toString().getBytes());
		}
		
        for(int i=0; i<Patienttotal; i++){
        	StringBuffer sbpatient = new StringBuffer();
        	int age = rd.nextInt(90)+1;
        	sbpatient.append("<patient pname=\"name" + Integer.toString(i) + "\" age=\"" + Integer.toString(age) + "\">");
        	int diseasenum = rd.nextInt(MaxDiseaseNum)+1;
        	int diseasenos[] = new int[diseasenum];
        	String doctorname[] = new String[diseasenum];
        	boolean experiment[] = new boolean[diseasenum];
        	int j=0;
        	while(j<diseasenum){
        		int diseaseno = rd.nextInt(20);
        		int k=0;
        		for (k=0; k<j; k++){
        			if (diseaseno == diseasenos[k]){
        				break;
        			}
        		}
        		if (k < j){
        			continue;
        		}else{
        			diseasenos[j] = diseaseno;
        			j++;
        		}
        	}
        	for (j=0; j<diseasenum; j++){
        		sbpatient.append("<disease>" + diseases[diseasenos[j]] + "</disease>");
        	}
        	
        	//add experiment
        	int experimenttreatnum = 0;
        	for(j=0; j<diseasenum; j++){
        		int doctorno = rd.nextInt(doctors[diseasenos[j]].length);
        		if ((diseasenos[j] == 1) || (diseasenos[j] == 3) || (diseasenos[j] ==10) 
        				|| (diseasenos[j] == 13) || (diseasenos[j] == 16)){
        			if (doctorno == 0){
        				experiment[j] = true;
        				experimenttreatnum = experimenttreatnum +2;
        			}else{
        				experiment[j] = false;
        			}
        		}else{
        			experiment[j] = false;
        		}
        		doctorname[j] = doctors[diseasenos[j]][doctorno];
        	}
        	
        	String experimenttreats[] = new String[experimenttreatnum];
        	int experimenttreatno = 0;
        	for(j=0; j<diseasenum; j++){
        		if ((diseasenos[j] == 1) && experiment[j]){
        			experimenttreats[experimenttreatno] = "treat2";
        			experimenttreatno++;
        			experimenttreats[experimenttreatno] = "treat3";
        			experimenttreatno++;       			
        		}else if ((diseasenos[j] == 3) && experiment[j]){
            			experimenttreats[experimenttreatno] = "treat10";
            			experimenttreatno++;
            			experimenttreats[experimenttreatno] = "treat11";
            			experimenttreatno++;       			
            	}else if ((diseasenos[j] == 10) && experiment[j]){
        			experimenttreats[experimenttreatno] = "treat23";
        			experimenttreatno++;
        			experimenttreats[experimenttreatno] = "treat24";
        			experimenttreatno++;       			
        		}else if ((diseasenos[j] == 13) && experiment[j]){
        			experimenttreats[experimenttreatno] = "treat28";
        			experimenttreatno++;
        			experimenttreats[experimenttreatno] = "treat29";
        			experimenttreatno++;       			
        		}else if ((diseasenos[j] == 16) && experiment[j]){
        			experimenttreats[experimenttreatno] = "treat34";
        			experimenttreatno++;
        			experimenttreats[experimenttreatno] = "treat35";
        			experimenttreatno++;       			
        		}
        	}
        	sbpatient.append("<treatments>");
        	ArrayList treats = new ArrayList();
        	for(j=0; j<diseasenum; j++){
        		for(int k=0; k<treatments[diseasenos[j]].length; k++){
        			int l=0;
        			for(l=0; l<experimenttreats.length; l++){
        				if (treatments[diseasenos[j]][k].equals(experimenttreats[l])){
        					break;
        				}       				
        			}
        			if (l == experimenttreats.length){
            			for(l=0; l<treats.size(); l++){
            				String tr = (String)treats.get(l);
            				if (treatments[diseasenos[j]][k].equals(tr)){
            					break;
            				}
            			}
            			if (l == treats.size()){
            				treats.add(treatments[diseasenos[j]][k]);
            			}        				
        			}
        		}
        	}
        	for(j=0; j<treats.size(); j++){
        		String tr = (String)treats.get(j);
        		sbpatient.append("<treatment>" + tr + "</treatment>");
        	}
        	if (experimenttreats.length > 0){
        		sbpatient.append("<experiment>");
        		for(j=0; j<experimenttreats.length; j++){
        			sbpatient.append("<treatment>" + experimenttreats[j] + "</treatment>");
        		}
        		sbpatient.append("</experiment>");
        	}
        	
        	sbpatient.append("</treatments>");
        	for(j=0; j<diseasenum; j++){
        		sbpatient.append("<doctor>Dr. " + doctorname[j] + "</doctor>");
        	}
        	
        	sbpatient.append("</patient>");
        	for(j=0; j<Filenum; j++){
        		if (i < ((Patienttotal/Filenum)*(j+1))){
        			outs[j].write(sbpatient.toString().getBytes());
        		}
        	}
        }
        
		StringBuffer sbtail=new StringBuffer();
        sbtail.append("</MedicalDB>");
        for(int i=0; i<Filenum; i++){
        	outs[i].write(sbtail.toString().getBytes());
        }
*/
		String diseases[] = {
			"Hypertension", "Heart Attack", "Apoplexy", "Bronchitis",
			"Cirrhosis", "Gastric Ulcer", "Influenza", "Rheumatoid Arthritis",
			"Neurasthenia", "Cataract", "Heterotropia", "Pharyngitis",
			"Diabetes", "Headache", "Scabies", "Anemia",
			"Angina Pectoris", "Arteriosclerosis", "Leukemia", "Malnutrition"
		};

		String treatments[][] = {
			{"treatment1", "treatment2", "treatment3", "treatment4", "treatment5", "treatment6", "treatment7", "treatment89", "treatment90"},
			{"treatment2", "treatment8", "treatment9", "treatment10", "treatment11", "treatment12", "treatment88", "treatment14", "treatment91", "treatment92"},
			{"treatment59", "treatment12", "treatment15", "treatment16", "treatment17", "treatment18", "treatment93", "treatment94"},
			{"treatment19", "treatment20", "treatment21", "treatment22", "treatment23", "treatment95", "treatment96"},
			{"treatment60", "treatment10", "treatment11", "treatment66", "treatment83", "treatment25", "treatment26", "treatment86", "treatment28", "treatment97", "treatment98"},
			{"treatment1", "treatment2", "treatment83", "treatment29", "treatment30", "treatment31", "treatment99", "treatment100"},
			{"treatment1", "treatment61", "treatment11", "treatment68", "treatment32", "treatment33", "treatment34", "treatment101", "treatment102"},
			{"treatment35", "treatment36", "treatment80", "treatment38", "treatment39", "treatment87", "treatment103", "treatment104"},
			{"treatment7", "treatment12", "treatment65", "treatment71", "treatment33", "treatment41", "treatment42", "treatment43", "treatment105", "treatment106"},
			{"treatment60", "treatment12", "treatment69", "treatment71", "treatment87", "treatment44", "treatment45", "treatment46", "treatment85", "treatment107", "treatment108"},
			{"treatment10", "treatment63", "treatment65", "treatment86", "treatment71", "treatment75", "treatment48", "treatment49", "treatment109", "treatment110"},
			{"treatment3", "treatment7", "treatment13", "treatment66", "treatment69", "treatment37", "treatment111", "treatment112"},
			{"treatment59", "treatment62", "treatment64", "treatment66", "treatment68", "treatment76", "treatment50", "treatment51", "treatment113", "treatment114"},
			{"treatment2", "treatment64", "treatment71", "treatment72", "treatment75", "treatment76", "treatment77", "treatment52", "treatment53", "treatment115", "treatment116"},
			{"treatment63", "treatment24", "treatment33", "treatment74", "treatment54", "treatment117", "treatment118"},
			{"treatment11", "treatment65", "treatment67", "treatment43", "treatment47", "treatment81", "treatment55", "treatment119", "treatment120"},
			{"treatment11", "treatment66", "treatment27", "treatment33", "treatment40", "treatment77", "treatment121", "treatment122"},
			{"treatment14", "treatment70", "treatment71", "treatment84", "treatment78", "treatment56", "treatment123", "treatment124"},
			{"treatment62", "treatment12", "treatment79", "treatment73", "treatment84", "treatment43", "treatment57", "treatment125", "treatment126"},
			{"treatment68", "treatment72", "treatment82", "treatment54", "treatment58", "treatment127", "treatment128"}
		};
		/* rules:
		   treat4, treat5, hypertenson
		   treat8, treat9, heart attack
		   treat15, treat16, Apoplexy
		   treat17, treat18, Apoplexy
		   treat21, treat22, Bronchitis
		   treat25, treat26, Cirrhosis
		   treat29, treat30, Gastric Ulcer
		   treat32, treat34, Influenza
		   treat35, treat36, Rheumatoid Arthritis
		   treat38, treat39, Rheumatoid Arthritis
		   treat41, treat42, Neurasthenia
		   treat44, treat45, Cataract
		   treat48, treat49, Heterotropia
		   treat13, treat37, Pharyngitis
		   treat50, treat51, Diabetes
		   treat52, treat53, Headache
		   treat24, treat74, Scabies
		   treat47, treat55, Anemia
		   treat27, treat40, Angina Pectoris
		   treat78, treat56, Arteriosclerosis
		   treat36, treat57, Leukemia
		   treat82, treat58, Malnutrition
		 */
		String doctors[][] = {
				{"Brown", "Baker", "Brain", "Bird", "Bull", "Brook"},
				{"Smith", "Bush", "Cotton", "Carter", "Cook"},
				{"Churchill", "Clinton", "Charles", "Black"},
				{"Cock", "David", "Dutt", "Edward", "Field"},
				{"Flower", "Frank", "Green", "Hunter", "Hill"},
				{"Fox", "Finger", "Hard", "Hawk", "Hand", "King" },
				{"Kent", "Jane", "Johnson", "Longman", "Lake"},
				{"Lily",  "Mill", "Macadam", "Leger", "London"},
				{"Law", "Lee", "Leonard", "Lewis"},
				{"Mark", "Miller", "Martin", "Moulton", "More" },
				{"Morgan", "Morley", "Moses", "Nell", "Nelson" },
				{"Newman", "Nixon", "Norton", "Noah", "Norris"},
				{"Occam", "Oliver", "Owen", "Pearson", "Peter"},
				{"Price", "Powell", "Pulitzer", "Pullman", "Powell", "Quiller"},
				{"Richard", "Reed", "Ralph", "Robert", "Robinson"},
				{"Roland", "Rose", "Russell", "Ruth", "Sam"},
				{"Samuel", "Sara", "Sawyer", "Scott", "Sharp"},
				{"Short", "Simon", "Snow", "Spencer", "Stella", "Sterling"},
				{"Stone", "Strong", "Sweet", "Taylor", "Turner"},
				{"Waters", "Well", "Victor", "Wood", "Wolf", "White","Washington"}
		};
		/*
		 * rules
		 * experiments: smith treat2, treat8
		 * experiments: Edward treat20, treat21
		 * experiments: Hunter treat26, treat28
		 * experiments: Longman treat32, treat33
		 * experiments: Lee	treat65, treat41
		 * experiments: Morley treat71, treat48
		 * experiments: Occam treat68, treat51
		 * experiments: Ralph treat74, treat54
		 * experiments: Roland treat67, treat55
		 * experiments: Simon treat70, treat56
		 */
/*		String symptoms[][] = {
				{"symp1", "symp2", "symp3", "symp4", "symp5", "symp6", "symp7"},
				{"symp1", "symp8", "symp9", "symp10", "symp11", "symp12", "symp13"},
				{"symp5", "symp10", "symp14", "symp15", "symp16", "symp17", "symp18"},
				{"symp3", "symp4", "symp7", "symp12", "symp15", "symp19"},
				{"symp2", "symp9", "symp10", "symp16", "symp18", "symp20", "symp21"},
				{"symp3", "symp7", "symp11", "symp17", "symp19", "symp22"},
				{"symp8", "symp12", "symp13", "symp21", "symp22", "symp23"},
				{"symp7", "symp10", "symp14", "symp18", "symp24", "symp25", "symp26"},
				{"symp4", "symp6", "symp11", "symp13", "symp20", "symp22", "symp27"},
				{"symp15", "symp19", "symp21", "symp24", "symp28", "symp29"},
				{"symp5", "symp16", "symp17", "symp20", "symp23", "symp27", "symp30"},
				{"symp9", "symp13", "symp15", "symp24", "symp26", "symp31", "symp32"},
				{"symp6", "symp10", "symp19", "symp20", "symp29", "symp33"},
				{"symp5", "symp13", "symp17", "symp22", "symp28", "symp30", "symp34"},
				{"symp12", "symp14", "symp21", "symp23", "symp29", "symp30"},
				{"symp9", "symp11", "symp25", "symp32", "symp35", "symp36", "symp37"},
				{"symp1", "symp2", "symp13", "symp19", "symp26", "symp33", "symp38"},
				{"symp4", "symp13", "symp20", "symp24", "symp27", "symp39"},
				{"symp7", "symp9", "symp19", "symp25", "symp32", "symp40", "symp41"},
				{"symp10", "symp21", "symp22", "symp23", "symp35", "symp42"},
				
		};*/
		String symptoms[][] = {
				{"symptom1", "symptom2", "symptom3", "symptom4", "symptom5", "symptom63", "symptom7", "symptom72", "symptom73"},
				{"symptom43", "symptom8", "symptom9", "symptom10", "symptom56", "symptom66", "symptom52", "symptom74", "symptom75"},
				{"symptom5", "symptom47", "symptom14", "symptom15", "symptom60", "symptom65", "symptom49", "symptom76", "symptom77"},
				{"symptom44", "symptom45", "symptom7", "symptom66", "symptom49", "symptom51", "symptom78", "symptom79"},
				{"symptom2", "symptom9", "symptom47", "symptom60", "symptom18", "symptom20", "symptom71", "symptom80", "symptom81"},
				{"symptom44", "symptom7", "symptom56", "symptom65", "symptom19", "symptom22", "symptom82", "symptom83"},
				{"symptom46", "symptom66", "symptom13", "symptom71", "symptom51", "symptom23", "symptom84", "symptom85"},
				{"symptom7", "symptom47", "symptom48", "symptom49", "symptom70", "symptom25", "symptom26", "symptom86", "symptom87"},
				{"symptom45", "symptom63", "symptom11", "symptom52", "symptom50", "symptom51", "symptom27", "symptom88", "symptom89"},
				{"symptom49", "symptom51", "symptom71", "symptom70", "symptom28", "symptom29", "symptom90", "symptom91"},
				{"symptom5", "symptom16", "symptom65", "symptom50", "symptom53", "symptom57", "symptom30", "symptom92", "symptom93"},
				{"symptom9", "symptom52", "symptom49", "symptom70", "symptom69", "symptom31", "symptom32", "symptom94", "symptom95"},
				{"symptom6", "symptom47", "symptom51", "symptom50", "symptom67", "symptom33","symptom96", "symptom97"},
				{"symptom5", "symptom52", "symptom17", "symptom51", "symptom58", "symptom61", "symptom34", "symptom98", "symptom99"},
				{"symptom12", "symptom48", "symptom71", "symptom53", "symptom59", "symptom61", "symptom101", "symptom100"},
				{"symptom9", "symptom56", "symptom54", "symptom62", "symptom35", "symptom36", "symptom37", "symptom102", "symptom103"},
				{"symptom43", "symptom2", "symptom52", "symptom51", "symptom55", "symptom64", "symptom38", "symptom104", "symptom105"},
				{"symptom45", "symptom52", "symptom50", "symptom24", "symptom57", "symptom39", "symptom106", "symptom107"},
				{"symptom7", "symptom9", "symptom51", "symptom54", "symptom62", "symptom40", "symptom41", "symptom108", "symptom109"},
				{"symptom47", "symptom21", "symptom51", "symptom53", "symptom68", "symptom42", "symptom110", "symptom111"},
				
		};		
	       /*
         * rules
         * symp1 symp3  treat4
         * symp1 symp4  treat6 
         * symp8 symp10  treat9
         * symp14 symp15 treat17 
         * symp18 symp20 treat26
         * symp19 symp22 treat30
         * symp13 symp23 treat34
         * symp25 symp26 treat38
         * symp11 symp27 treat41
         * symp28 symp29 treat44
         * symp16 symp30 treat49
         * symp31 symp32 treat66
         * symp6 symp33 treat51
         * symp17 symp34 treat52
         * symp12 symp59 treat54
         * symp35 symp37 treat55
         * symp55 symp38 treat40
         * symp24 symp39 treat56
         * symp40 symp41 treat57
         * symp21 symp42 treat58
         */
		int diseaseelenum = 0;
		int treatelenum = 0;
		int expelenum = 0;
		int sympelenum = 0;
		
		Random rd=new Random(System.currentTimeMillis());
		
		FileOutputStream outs[] = new FileOutputStream[Filenum];
		StringBuffer sbhead=new StringBuffer();
        sbhead.append("<MedicalDB>");
		for(int i=0; i<Filenum; i++){
//			File xmlfile = new File("C:\\MedicalDB" + Integer.toString((Patienttotal/Filenum)*(i+1)) + ".xml");
			File xmlfile = new File(directoryPath + File.separator + "MedicalDB" + Integer.toString((Patienttotal/Filenum)*(i+1)) + ".xml");
			if (xmlfile.exists()){
				System.out.println("File exists!");
				return;
			}
			xmlfile.createNewFile();
			outs[i] = new FileOutputStream(xmlfile,true);
			outs[i].write(sbhead.toString().getBytes());
		}
		
        for(int i=0; i<Patienttotal; i++){
        	StringBuffer sbpatient = new StringBuffer();
        	int age = rd.nextInt(90)+1;
        	sbpatient.append("<patient pname=\"name" + Integer.toString(i) + "\" age=\"" + Integer.toString(age) + "\">");
        	int diseasenum = rd.nextInt(MaxDiseaseNum)+1;
        	diseaseelenum = diseaseelenum + diseasenum;
        	int diseasenos[] = new int[diseasenum];
        	String doctorname[] = new String[diseasenum];
        	boolean experiment[][] = new boolean[10][2];
        	int j=0;
        	while(j<diseasenum){
        		int diseaseno = rd.nextInt(20);
        		int k=0;
        		for (k=0; k<j; k++){
        			if (diseaseno == diseasenos[k]){
        				break;
        			}
        		}
        		if (k < j){
        			continue;
        		}else{
        			diseasenos[j] = diseaseno;
        			j++;
        		}
        	}
        	for (j=0; j<diseasenum; j++){
        		int doctorno = rd.nextInt(doctors[diseasenos[j]].length);
        		doctorname[j] = doctors[diseasenos[j]][doctorno];
        		if (doctorname[j].equals("Smith")){
        			experiment[0][0] = true;
        		}else if(doctorname[j].equals("Edward")){
        			experiment[1][0] = true;
        		}else if(doctorname[j].equals("Hunter")){
        			experiment[2][0] = true;
        		}else if(doctorname[j].equals("Longman")){
        			experiment[3][0] = true;
        		}else if(doctorname[j].equals("Lee")){
        			experiment[4][0] = true;
        		}else if(doctorname[j].equals("Morley")){
        			experiment[5][0] = true;
        		}else if(doctorname[j].equals("Occam")){
        			experiment[6][0] = true;
        		}else if(doctorname[j].equals("Ralph")){
        			experiment[7][0] = true;
        		}else if(doctorname[j].equals("Roland")){
        			experiment[8][0] = true;
        		}else if(doctorname[j].equals("Simon")){
        			experiment[9][0] = true;
        		}
        		sbpatient.append("<disease dname=\"" + diseases[diseasenos[j]] + "\">" + "<doctor>" + doctorname[j] + "</doctor>" + "</disease>");
        	}
        	
        	//add symptoms
        	/* symps: the symptoms number for one disease */
        	int symps[] = new int[diseasenum];
        	int sympnum = 0; // total number of symptoms(expected) 
        	for(j=0; j<diseasenum; j++){
        		//symps[j] = rd.nextInt(symptoms[diseasenos[j]].length - MinSympNum);
        		symps[j] = rd.nextInt(MaxSympNum - MinSympNum);
        		symps[j] = symps[j] + MinSympNum;
        		sympnum = sympnum + symps[j];
        	}
        	String psymps[] = new String[sympnum]; //all the symptoms
        	int l=0; 
        	for(j=0; j<diseasenum; j++){
        		int sympsno[] = new int[symps[j]]; //the no. of symtoms for one disease
        		for(int k=0; k<symps[j]; k++){
        			int sympno = rd.nextInt(symptoms[diseasenos[j]].length);
        			int m=0;
        			for (m=0; m<k; m++){
        				if (sympsno[m] == sympno){
        					break;
        				}      				
        			}
        			if (m<k){
        				k--;
        				continue;
        			}
        			sympsno[k] = sympno;
        		}
        		for(int k=0; k<symps[j]; k++){
        			int m=0;
        			for(m=0; m<l; m++){
        				if (psymps[m].equals(symptoms[diseasenos[j]][sympsno[k]])){
        					break;
        				}
        			}
        			if (m==l){
        				psymps[l] = symptoms[diseasenos[j]][sympsno[k]];
        				l++;
        			}
        		}
        	}
        	//now l is the real number of symptoms
        	sympnum = l;
        	sympelenum = sympelenum + sympnum;
        	sbpatient.append("<symptoms>");
        	for (j=0; j<sympnum; j++){
        		sbpatient.append("<symptom>" + psymps[j] + "</symptom>");
        	}
        	sbpatient.append("</symptoms>");
        	//add treatments and experiment
   
    		boolean symprule1[] = new boolean[20];
    		boolean symprule2[] = new boolean[20];
        	for(j=0; j<sympnum; j++){
        		if (psymps[j].equals("symptom1")){
        			symprule1[0] = true;
        			symprule1[1] = true;
        		}else if (psymps[j].equals("symptom3")){
        			symprule2[0] = true;
        		}else if (psymps[j].equals("symptom4")){
        			symprule2[1] = true;
        		}else if (psymps[j].equals("symptom6")){
        			symprule1[12] = true;
        		}else if (psymps[j].equals("symptom8")){
        			symprule1[2] = true;
        		}else if (psymps[j].equals("symptom10")){
        			symprule2[2] = true;
        		}else if (psymps[j].equals("symptom11")){
        			symprule1[8] = true;
        		}else if (psymps[j].equals("symptom12")){
        			symprule1[14] = true;
        		}else if (psymps[j].equals("symptom13")){
        			symprule1[6] = true;
        		}else if (psymps[j].equals("symptom14")){
        			symprule1[3] = true;
        		}else if (psymps[j].equals("symptom15")){
        			symprule2[3] = true;
        		}else if (psymps[j].equals("symptom16")){
        			symprule1[10] = true;
        		}else if (psymps[j].equals("symptom17")){
        			symprule1[13] = true;
        		}else if (psymps[j].equals("symptom18")){
        			symprule1[4] = true;
        		}else if (psymps[j].equals("symptom19")){
        			symprule1[5] = true;
        		}else if (psymps[j].equals("symptom20")){
        			symprule2[4] = true;
        		}else if (psymps[j].equals("symptom21")){
        			symprule1[19] = true;
        		}else if (psymps[j].equals("symptom22")){
        			symprule2[5] = true;
        	//		symprule1[8] = true;
        		}else if (psymps[j].equals("symptom23")){
        			symprule2[6] = true;
        		}else if (psymps[j].equals("symptom24")){
        			symprule1[17] = true;
        		}else if (psymps[j].equals("symptom25")){
        			symprule1[7] = true;
        		}else if (psymps[j].equals("symptom26")){
        			symprule2[7] = true;
        		}else if (psymps[j].equals("symptom27")){
        			symprule2[8] = true;
        		//	symprule1[10] = true;
        		}else if (psymps[j].equals("symptom28")){
        			symprule1[9] = true;
        		}else if (psymps[j].equals("symptom29")){
        			symprule2[9] = true;
        		}else if (psymps[j].equals("symptom30")){
        			symprule2[10] = true;
        		//	symprule2[14] = true;
        		}else if (psymps[j].equals("symptom31")){
        			symprule1[11] = true;
        		}else if (psymps[j].equals("symptom32")){
        			symprule2[11] = true;
        		}else if (psymps[j].equals("symptom33")){
        			symprule2[12] = true;
        		//	symprule1[16] = true;
        		}else if (psymps[j].equals("symptom34")){
        			symprule2[13] = true;
        		}else if (psymps[j].equals("symptom35")){
        			symprule1[15] = true;
        		}else if (psymps[j].equals("symptom37")){
        			symprule2[15] = true;
        		}else if (psymps[j].equals("symptom38")){
        			symprule2[16] = true;
        		}else if (psymps[j].equals("symptom39")){
        			symprule2[17] = true;
        		}else if (psymps[j].equals("symptom40")){
        			symprule1[18] = true;
        		}else if (psymps[j].equals("symptom41")){
        			symprule2[18] = true;
        		}else if (psymps[j].equals("symptom42")){
        			symprule2[19] = true;
        		}else if (psymps[j].equals("symptom55")){
        			symprule1[16] = true;
        		}else if (psymps[j].equals("symptom59")){
        			symprule2[14] = true;
        		}
        	}
        	
        	int treats[] = new int[diseasenum];
        	int treatnum = 0;
        	for(j=0; j<diseasenum; j++){
        		//get the number of treatments
        		//treats[j] = rd.nextInt(symptoms[diseasenos[j]].length - MinTreatNum);
        		treats[j] = rd.nextInt(MaxTreatNum - MinTreatNum);
        		treats[j] = treats[j] + MinTreatNum;
        		treatnum = treatnum + treats[j];       		
        	}
        	String ptreats[] = new String[treatnum];
        	l=0;
        	for(j=0; j<diseasenum; j++){
        		int treatnos[] = new int[treats[j]]; //the no. of symtoms for one disease
        		int diseaseno = diseasenos[j];
        		int hastreat = 0;
        		switch(diseaseno){
	        		case 0: {
	        			if ((symprule1[0]) &&(symprule2[0])){
        					treatnos[hastreat] = 3;
        					hastreat++;
        				}
		        		if ((symprule1[1]) &&(symprule2[1])){
							treatnos[hastreat] = 5;
							hastreat++;
						}
		        		break;
        			}
	        		case 1: {
    					if ((symprule1[2]) &&(symprule2[2])){
    						treatnos[hastreat] = 2;
    						hastreat++;
						}
    					break;
    				}
	        		case 2: {
						if ((symprule1[3]) &&(symprule2[3])){
							treatnos[hastreat] = 4;
							hastreat++;
						}
						break;
					}
	        		case 4: {
						if ((symprule1[4]) &&(symprule2[4])){
							treatnos[hastreat] = 6;
							hastreat++;
						}
						break;
					}
	        		case 5: {
						if ((symprule1[5]) &&(symprule2[5])){
							treatnos[hastreat] = 4;
							hastreat++;
						}
						break;
					}
	        		case 6: {
						if ((symprule1[6]) &&(symprule2[6])){
							treatnos[hastreat] = 6;
							hastreat++;
						}
						break;
					}
	        		case 7: {
						if ((symprule1[7]) &&(symprule2[7])){
							treatnos[hastreat] = 3;
							hastreat++;
						}
						break;
					}
	        		case 8: {
						if ((symprule1[8]) &&(symprule2[8])){
							treatnos[hastreat] = 5;
							hastreat++;
						}
						break;
					}
	        		case 9: {
						if ((symprule1[9]) &&(symprule2[9])){
							treatnos[hastreat] = 5;
							hastreat++;
						}
						break;
					}
	        		case 10: {
						if ((symprule1[10]) &&(symprule2[10])){
							treatnos[hastreat] = 7;
							hastreat++;
						}
						break;
					}
	        		case 11: {
						if ((symprule1[11]) &&(symprule2[11])){
							treatnos[hastreat] = 3;
							hastreat++;
						}
						break;
					}
	        		case 12: {
						if ((symprule1[12]) &&(symprule2[12])){
							treatnos[hastreat] = 7;
							hastreat++;
						}
						break;
					}
	        		case 13: {
						if ((symprule1[13]) &&(symprule2[13])){
							treatnos[hastreat] = 7;
							hastreat++;
						}
						break;
					}
	        		case 14: {
						if ((symprule1[14]) &&(symprule2[14])){
							treatnos[hastreat] = 4;
							hastreat++;
						}
						break;
					}
	        		case 15: {
						if ((symprule1[15]) &&(symprule2[15])){
							treatnos[hastreat] = 6;
							hastreat++;
						}
						break;
					}
	        		case 16: {
						if ((symprule1[16]) &&(symprule2[16])){
							treatnos[hastreat] = 4;
							hastreat++;
						}
						break;
					}
	        		case 17: {
						if ((symprule1[17]) &&(symprule2[17])){
							treatnos[hastreat] = 5;
							hastreat++;
						}
						break;
					}
	        		case 18: {
						if ((symprule1[18]) &&(symprule2[18])){
							treatnos[hastreat] = 6;
							hastreat++;
						}
						break;
					}
	        		case 19: {
						if ((symprule1[19]) &&(symprule2[19])){
							treatnos[hastreat] = 4;
							hastreat++;
						}
						break;
					}
      			
        		}        		
        		for(int k=hastreat; k<treats[j]; k++){
        			int treatno = rd.nextInt(treatments[diseaseno].length);
        			int m=0;
        			for(m=0; m<k; m++){
        				if (treatnos[m] == treatno){
        					break;
        				}
        			}
        			if (m<k){
        				k--;
        				continue;
        			}
        			treatnos[k] = treatno;
        		}
        		for(int k=0; k<treats[j]; k++){
        			int m=0;
        			for(m=0; m<l; m++){
        				if (ptreats[m].equals(treatments[diseaseno][treatnos[k]])){
        					break;
        				}
        			}
        			if (m<l){
        				continue;
        			}
        			/*
        			 * rules
        			 * experiments: smith treat2, treat8
        			 * experiments: Edward treat20, treat21
        			 * experiments: Hunter treat26, treat28
        			 * experiments: Longman treat32, treat33
        			 * experiments: Lee	treat65, treat41
        			 * experiments: Morley treat71, treat48
        			 * experiments: Occam treat68, treat51
        			 * experiments: Ralph treat74, treat54
        			 * experiments: Roland treat67, treat55
        			 * experiments: Simon treat70, treat56
        			 */
        			ptreats[l] = treatments[diseaseno][treatnos[k]];
 /*       			if (ptreats[l].equals("treat2")){
        				experiment[0][1] = true;
        			}else if (ptreats[l].equals("treat8")){
        				experiment[0][1] = true;
        			}else if (ptreats[l].equals("treat20")){
        				experiment[1][1] = true;
        			}else if (ptreats[l].equals("treat21")){
        				experiment[1][1] = true;
        			}else if (ptreats[l].equals("treat26")){
        				experiment[2][1] = true;
        			}else if (ptreats[l].equals("treat28")){
        				experiment[2][1] = true;
        			}else if (ptreats[l].equals("treat32")){
        				experiment[3][1] = true;
        			}else if (ptreats[l].equals("treat33")){
        				experiment[3][1] = true;
        			}else if (ptreats[l].equals("treat65")){
        				experiment[4][1] = true;
        			}else if (ptreats[l].equals("treat41")){
        				experiment[4][1] = true;
        			}else if (ptreats[l].equals("treat71")){
        				experiment[5][1] = true;
        			}else if (ptreats[l].equals("treat48")){
        				experiment[5][1] = true;
        			}else if (ptreats[l].equals("treat68")){
        				experiment[6][1] = true;
        			}else if (ptreats[l].equals("treat51")){
        				experiment[6][1] = true;
        			}else if (ptreats[l].equals("treat74")){
        				experiment[7][1] = true;
        			}else if (ptreats[l].equals("treat54")){
        				experiment[7][1] = true;
        			}else if (ptreats[l].equals("treat67")){
        				experiment[8][1] = true;
        			}else if (ptreats[l].equals("treat55")){
        				experiment[8][1] = true;
        			}else if (ptreats[l].equals("treat70")){
        				experiment[9][1] = true;
        			}else if (ptreats[l].equals("treat56")){
        				experiment[9][1] = true;
        			}*/
        			l++;
        		}
        	}
        	treatnum = l;
        	treatelenum = treatelenum + treatnum;
        	boolean hasexperiment = false;
        	//add treatments
        	String experimentstr = "<experiment>";
        	String treatmentstr = "";
        	for(j=0; j<treatnum; j++){
        		if (((ptreats[j].equals("treatment2") || ptreats[j].equals("treatment8"))&&experiment[0][0]) ||
        			((ptreats[j].equals("treatment20") || ptreats[j].equals("treatment21"))&&experiment[1][0]) ||
        			((ptreats[j].equals("treatment26") || ptreats[j].equals("treatment28"))&&experiment[2][0]) ||
        			((ptreats[j].equals("treatment32") || ptreats[j].equals("treatment33"))&&experiment[3][0]) ||
        			((ptreats[j].equals("treatment65") || ptreats[j].equals("treatment41"))&&experiment[4][0]) ||
        			((ptreats[j].equals("treatment71") || ptreats[j].equals("treatment48"))&&experiment[5][0]) ||
        			((ptreats[j].equals("treatment68") || ptreats[j].equals("treatment51"))&&experiment[6][0]) ||
        			((ptreats[j].equals("treatment74") || ptreats[j].equals("treatment54"))&&experiment[7][0]) ||
        			((ptreats[j].equals("treatment67") || ptreats[j].equals("treatment55"))&&experiment[8][0]) ||
        			((ptreats[j].equals("treatment70") || ptreats[j].equals("treatment56"))&&experiment[9][0])){
        				hasexperiment = true;
        				experimentstr = experimentstr + "<treatment>" + ptreats[j] + "</treatment>";
        		}else{
        			treatmentstr = treatmentstr + "<treatment>" + ptreats[j] + "</treatment>";
        		}
        	}
        	
        	sbpatient.append("<treatments>");
        	if (hasexperiment){
        		expelenum++;
        		sbpatient.append(experimentstr + "</experiment>");
        	}
        	sbpatient.append(treatmentstr + "</treatments>");
        	
   		 /* experiments: smith treat2, treat8
		 * experiments: Edward treat20, treat21
		 * experiments: Hunter treat27, treat28
		 * experiments: Longman treat32, treat33
		 * experiments: Lee	treat17, treat41
		 * experiments: Morley treat42, treat48
		 * experiments: Occam treat44, treat51
		 * experiments: Ralph treat39, treat54
		 * experiments: Roland treat22, treat55
		 * experiments: Simon treat30, treat56      */  	

        	sbpatient.append("</patient>");
        	for(j=0; j<Filenum; j++){
        		if (i < ((Patienttotal/Filenum)*(j+1))){
        			outs[j].write(sbpatient.toString().getBytes());
        		} 
        		if (i == ((Patienttotal/Filenum)*(j+1)) - 1){
        			System.out.println("File " + (i + 1) + ":");
        			System.out.println("disease number: " + diseaseelenum);
        			System.out.println("experiment number: " + expelenum);
        			System.out.println("treatment number: " + treatelenum);
        			System.out.println("symptom number: " + sympelenum);
        		}
        		
        	}
        }
        
		StringBuffer sbtail=new StringBuffer();
        sbtail.append("</MedicalDB>");
        for(int i=0; i<Filenum; i++){
        	outs[i].write(sbtail.toString().getBytes());
        	
        }
		
	}

		
}
